
//   *******    PINES DE ARDUINO UNO  *********

const int pinRed   = 1 ;   // LED Rojo     PWM
const int pinGreen = 2 ;  // LED Verde    PWM
const int pinBlue  = 3 ;  // LED Azul     PWM


//     *******    ARRAYS  con valores por defecto  *********

 byte dia[]   = {250,250,250} ;   // DIA          
 byte tarde[] = {100,50,0};       // ATARDECER   
 byte noche[] = {0,0,30};         // NOCHE          
 byte alba[]  = {70,30,10} ;      // AMANECER   

//     *******    VARIABLE DE USO GENERAL  *********
const int n_ciclos= 4;                     // cantidad de ciclos (DIA, ATARDECER,NOCHE,AMANECER)
int previoCiclo = 1;                       // Iniciamos el contador de ciclos
int currentCiclo = 1;
unsigned long intervalo = 30000;           // (30 segundos)x 1000. Duracion en milisegundos del intervalo de cada ciclo
unsigned long previoMillis = 0;            // Retendra el milisegundo en que comienzo del ultimo ciclo horario
 
 
 //     +++++++++++++++++    VOID SETUP     +++++++++++++++++++++
void setup() {
                 

 //     ++++++++++++    DECLARACION DE FUNCIONES DE USUARIO  +++++++++++++++++++++++ 
  
  pinMode(pinRed, OUTPUT);                 //-----------------------------------
  pinMode(pinGreen, OUTPUT);
  pinMode(pinBlue, OUTPUT);                // se declaran los pines como salida
     //-----------------------------------


  transicion(dia[0],dia[1],dia[2], dia[0],dia[1],dia[2]);
  previoMillis = millis();      // se guarda el milisegundo en el que ha producido el BIG BANG
}

void loop()
{

//  ------------------      CONTROL DEL TIEMPO  -------------------------------
 if (temporizador(previoMillis, intervalo)) // Se comprueba si ha finalizado el ciclo actual
  {
    // en caso afirmativo.........
    
    currentCiclo = cambioCiclo(previoCiclo,n_ciclos);    // se actualiza el ciclo que comienza
    previoCiclo= currentCiclo ;
    
        switch (currentCiclo)
    {
    case 1:        // COMIENZA EL DIA

         transicion(alba[0],alba[1],alba[2], dia[0],dia[1],dia[2]);
      
      break;
    case 2:        // COMIENZA EL ATARDECER

        transicion(dia[0],dia[1],dia[2], tarde[0],tarde[1],tarde[2]);
      break;
    case 3:        // COMIENZA LA NOCHE

        
         transicion(tarde[0],tarde[1],tarde[2], noche[0],noche[1],noche[2]);
      break;
    case 4:        // COMIENZA EL AMANECER

        transicion(noche[0],noche[1],noche[2], alba[0],alba[1],alba[2]);
      break;  
    default:
      currentCiclo = 1;
      break;
    }   
  previoMillis = millis();      // se guarda el milisegundo en el que ha comenzado el ciclo
    
    }
    

}


// ---------------------------------       FIN     ---------------------------------------------------
