// PROGRAMA PARA SIMULAR EL EFECTO AMANECER, DIA, TARDE Y NOCHE EN UN BELEN
// POR MEDIO DE UNA TIRA LED LED WS2812B DIRECCIONABLE DE MANERA INDIVIDUAL
// PROGRAMADOR : P. PABLO HERNANDEZ R.
// CORREO ELECTRONICO : pphrymyq@gmail.com
// GUATEMALA, SEPTIEMBRE DE 2018

//CONSTANTE PARA DEFINIR LA CANTIDAD DE LEDS QUE SE VAN A ADMINISTRAR EN LA TIRA LED RGB
#define NEO_PIXEL_LED_INICIAL 0
#define NEO_PIXEL_LED_FINAL 16
//#define NeoNumPixels 16

//INCLUSION DE LA LIBRERIA NEOPIXEL PARA LA PROGRAMACION DE LA TIRA LED RGB
#include <NeoPixel.h>
#ifdef __AVR_ATtiny85__ // Trinket, Gemma, etc.
  #include <avr/power.h>
#endif

//CONSTANTE PARA DEFINIR EL PIN DE CONTROL DE LA TIRA LED RGB
#define PIN  6

//ASIGNACION DE LA VARIABLE TIPO OBJETO PARA MANIPULAR EL LED CON SUS DIFERENTES METODOS
NeoPixel Tira_LED = NeoPixel(NEO_PIXEL_LED_FINAL, PIN, NEO_GRB + NEO_KHZ800 + NEO_PxB);
//NEO_PxB tells library to use a brightness array for each pixel

//CONSTANTES DE TIEMPO DE DURACION DE CADA FASE EN SEGUNDOS PARA USUARIO
#define TIEMPO_AMANECER 100
#define TIEMPO_DIA 100
#define TIEMPO_TARDE 100
#define TIEMPO_NOCHE 100

//CONSTANTES DE TIEMPO DE DURACION DE CADA FASE EN MILISEGUNDOS PARA ARDUINO
#define MILISEGUNDOS 100
#define TIEMPO_FASE_AMANECER = TIEMPO_AMANECER * MILISEGUNDOS
#define TIEMPO_FASE_DIA = TIEMPO_DIA *  MILISEGUNDOS
#define TIEMPO_FASE_TARDE = TIEMPO_TARDE * MILISEGUNDOS
#define TIEMPO_FASE_NOCHE = TIEMPO_NOCHE * MILISEGUNDOS

//CONSTANTES DE INCREMENTO O DECREMENTO DE INTENSIDAD PARA RGB
#define INTENSIDAD_MINIMA 0
#define INTENSIDAD_MAXIMA 255

//VARIABLES GLOBALES PARA CONTROLAR LOS TIEMPOS E INTENSIDAD DE ILUMINACION

//VARIABLES PARA CALCULAR EL INCREMENTO / DECREMENTO DE ILUMINACION EN CADA FASE
long DeltaAmanecer;
long DeltaDia;
long DeltaTarde;
long DeltaNoche;

//VARIABLES PARA ALMACENAR EL VALOR DE ILUMINACION DE LOS LEDS EN CADA FASE
int IluminacionAmanecer;
int IluminacionDia;
int IluminacionTarde;
int IluminacionNoche;

//VARIABLES DE CONTADOR PARA EL CICLO DE CADA FASE
int IteracionAmanecer;
int IteracionDia;
int IteracionTarde;
int IteracionNoche;

//VARIABLES PARA CONTROLAR EL FINAL DEL CONTADOR DEL CICLO DE CADA FASE
int IteracionFinalAmanecer;
int IteracionFinalDia;
int IteracionFinalTarde;  
int IteracionFinalNoche;

//PROCEDIMIENTO PARA ESPERAR N MILISEGUNDOS EN CADA ITERACION DE CADA FASE  
void Esperar(int Espera)
{
  unsigned long TiempoActual;
  unsigned long TiempoFinal;
  TiempoActual = millis();
  TiempoFinal = TiempoActual + Espera;

  while (TiempoActual < TiempoFinal)
  {
    TiempoActual = millis();
  }
}
//PROCEDIMIENTO QUE ACTIVA LA ILUMINACION DE LA FASE AMANECER
void Ilumina_Amanecer(int LED_INICIAL,int LED_FINAL, int INTENSIDAD_BRILLO)
{
  int Posicion_LED;
  for (Posicion_LED = LED_INICIAL; Posicion_LED <= LED_FINAL; Posicion_LED+=1)
  {
    //ASIGNO EL COLOR BLANCO GRISASEO A CADA POSICION DE LED
    Tira_LED.setPixelColor(Posicion_LED ,Tira_LED.Color(255,255,255));
    //ASIGNO EL BRILLO A CADA POSICION DE LED
    Tira_LED.setBrightnessPixel(INTENSIDAD_BRILLO,Posicion_LED);
  }  
  //SE HACE VISIBLE EL COLOR
  Tira_LED.show();
}
//PROCEDIMIENTO QUE EJECUTA LA FASE AMANECER
void Fase_Amanecer()
{
  
  DeltaAmanecer = 0;
  IluminacionAmanecer = 0;
  IteracionAmanecer = 0;
  IteracionFinalAmanecer = 0;
  
  IteracionFinalAmanecer = TIEMPO_AMANECER;
  DeltaAmanecer = INTENSIDAD_MAXIMA / TIEMPO_AMANECER;
  DeltaTarde = INTENSIDAD_MAXIMA / TIEMPO_AMANECER;
  
  IluminacionDia = INTENSIDAD_MINIMA;
  IluminacionTarde = INTENSIDAD_MAXIMA;
  IluminacionNoche = INTENSIDAD_MINIMA;  
  
  //CICLO QUE CONTROLA LA DURACION DE LA FASE AMANECER
  for (IteracionAmanecer = 0; IteracionAmanecer <= IteracionFinalAmanecer; IteracionAmanecer++)
  {
    IluminacionAmanecer = IteracionAmanecer * DeltaAmanecer;
    IluminacionTarde = IluminacionTarde - DeltaTarde;
    Serial.print("+++++ A M A N E C E R +++++ [ ");
    Serial.print(IteracionAmanecer);
    Serial.print(" - ");
    Serial.print(IteracionFinalAmanecer);
    Serial.print(" ] ");
    Serial.print("- I(amanecer) = ");
    Serial.print(IluminacionAmanecer);
    Serial.print(" - I(dia) = ");
    Serial.print(IluminacionDia);
    Serial.print(" - I(tarde) = ");
    Serial.print(IluminacionTarde);
    Serial.print(" - I(noche) = ");
    Serial.println(IluminacionNoche);    
    Ilumina_Amanecer(NEO_PIXEL_LED_INICIAL,NEO_PIXEL_LED_FINAL,IluminacionAmanecer);
    Esperar(MILISEGUNDOS);
  }
}

//PROCEDIMIENTO QUE ACTIVA LA ILUMINACION DE LA FASE AMANECER
void Ilumina_Dia(int LED_INICIAL,int LED_FINAL, int INTENSIDAD_BRILLO)
{
  int Posicion_LED;
  for (Posicion_LED = LED_INICIAL; Posicion_LED <= LED_FINAL; Posicion_LED+=1)
  {
    //ASIGNO EL COLOR AMARILLO SOL A CADA POSICION DE LED
    Tira_LED.setPixelColor(Posicion_LED ,Tira_LED.Color(51,153,255));
    //ASIGNO EL BRILLO A CADA POSICION DE LED
    Tira_LED.setBrightnessPixel(INTENSIDAD_BRILLO,Posicion_LED);
  }  
  //SE HACE VISIBLE EL COLOR
  Tira_LED.show();
}
//PROCEDIMIENTO QUE EJECUTA LA FASE DIA
void Fase_Dia()
{
  
  DeltaDia = 0;
  IluminacionDia = 0;
  IteracionDia = 0;
  IteracionFinalDia = 0;
  
  IteracionFinalDia = TIEMPO_DIA;

  IluminacionAmanecer = INTENSIDAD_MAXIMA;
  IluminacionDia = INTENSIDAD_MAXIMA;
  IluminacionTarde = INTENSIDAD_MINIMA;
  IluminacionNoche = INTENSIDAD_MINIMA;
  
  //CICLO QUE CONTROLA LA DURACION DE LA FASE DIA
  for (IteracionDia = 0; IteracionDia <= IteracionFinalDia; IteracionDia++)
  {
    Serial.print("+++++ D I A +++++ [ ");
    Serial.print(IteracionDia);
    Serial.print(" - ");
    Serial.print(IteracionFinalDia);
    Serial.print(" ] ");
    Serial.print("- I(amanecer) = ");
    Serial.print(IluminacionAmanecer);
    Serial.print(" - I(dia) = ");
    Serial.print(IluminacionDia);
    Serial.print(" - I(tarde) = ");
    Serial.print(IluminacionTarde);
    Serial.print(" - I(noche) = ");
    Serial.println(IluminacionNoche);    
    Ilumina_Dia(NEO_PIXEL_LED_INICIAL,NEO_PIXEL_LED_FINAL,IluminacionDia);
    Esperar(MILISEGUNDOS);
  }
}

//PROCEDIMIENTO QUE ACTIVA LA ILUMINACION DE LA FASE AMANECER
void Ilumina_Tarde(int LED_INICIAL,int LED_FINAL, int INTENSIDAD_BRILLO)
{
  int Posicion_LED;
  for (Posicion_LED = LED_INICIAL; Posicion_LED <= LED_FINAL; Posicion_LED+=1)
  {
    //ASIGNO EL COLOR ROJO ORIENTE A CADA POSICION DE LED    
    Tira_LED.setPixelColor(Posicion_LED ,Tira_LED.Color(255,117,20));
    //ASIGNO EL BRILLO A CADA POSICION DE LED
    Tira_LED.setBrightnessPixel(INTENSIDAD_BRILLO,Posicion_LED);
  }  
  //SE HACE VISIBLE EL COLOR
  Tira_LED.show();
}

//PROCEDIMIENTO QUE EJECUTA LA FASE TARDE
void Fase_Tarde()
{
  
  DeltaTarde = 0;
  IluminacionTarde = 0;
  IteracionTarde = 0;
  IteracionFinalTarde = 0;
  
  IteracionFinalTarde = TIEMPO_TARDE;
  DeltaAmanecer = INTENSIDAD_MAXIMA / TIEMPO_TARDE;
  DeltaTarde = INTENSIDAD_MAXIMA / TIEMPO_TARDE;
  
  IluminacionAmanecer = INTENSIDAD_MAXIMA;
  IluminacionDia = INTENSIDAD_MINIMA;
  IluminacionNoche = INTENSIDAD_MINIMA; 
  
  //CICLO QUE CONTROLA LA DURACION DE LA FASE TARDE
  for (IteracionTarde = 0; IteracionTarde <= IteracionFinalTarde; IteracionTarde++)
  {
    IluminacionAmanecer = IluminacionAmanecer - DeltaAmanecer;
    IluminacionTarde = IteracionTarde * DeltaTarde;
    Serial.print("+++++ T A R D E +++++ [ ");
    Serial.print(IteracionTarde);
    Serial.print(" - ");
    Serial.print(IteracionFinalTarde);
    Serial.print(" ] ");    
    Serial.print("- I(amanecer) = ");
    Serial.print(IluminacionAmanecer);
    Serial.print(" - I(dia) = ");
    Serial.print(IluminacionDia);
    Serial.print(" - I(tarde) = ");
    Serial.print(IluminacionTarde);
    Serial.print(" - I(noche) = ");
    Serial.println(IluminacionNoche);
    Ilumina_Dia(NEO_PIXEL_LED_INICIAL,NEO_PIXEL_LED_FINAL,IluminacionTarde);
    Esperar(MILISEGUNDOS);
  }
}

//PROCEDIMIENTO QUE ACTIVA LA ILUMINACION DE LA FASE AMANECER
void Ilumina_Noche(int LED_INICIAL,int LED_FINAL, int INTENSIDAD_BRILLO)
{
  int Posicion_LED;
  for (Posicion_LED = LED_INICIAL; Posicion_LED <= LED_FINAL; Posicion_LED+=1)
  {
    //ASIGNO EL COLOR AZUL NOCHE PERLADO A CADA POSICION DE LED
    Tira_LED.setPixelColor(Posicion_LED ,Tira_LED.Color(0,0,153));
    //ASIGNO EL BRILLO A CADA POSICION DE LED
    Tira_LED.setBrightnessPixel(INTENSIDAD_BRILLO,Posicion_LED);
  }  
  //SE HACE VISIBLE EL COLOR
  Tira_LED.show();
}

//PROCEDIMIENTO QUE EJECUTA LA FASE NOCHE
void Fase_Noche()
{
  
  DeltaNoche = 0;
  IluminacionNoche = 0;
  IteracionNoche = 0;
  IteracionFinalNoche = 0;
  
  IteracionFinalNoche = TIEMPO_NOCHE;
  
  IluminacionAmanecer = INTENSIDAD_MINIMA;
  IluminacionDia = INTENSIDAD_MINIMA;
  IluminacionTarde = INTENSIDAD_MAXIMA;
  IluminacionNoche = INTENSIDAD_MAXIMA;

  //CICLO QUE CONTROLA LA DURACION DE LA FASE NOCHE
  for (IteracionNoche = 0; IteracionNoche <= IteracionFinalNoche; IteracionNoche++)
  {
    Serial.print("+++++ N O C H E +++++ [ ");
    Serial.print(IteracionNoche);
    Serial.print(" - ");
    Serial.print(IteracionFinalNoche);
    Serial.print(" ] ");    
    Serial.print("- I(amanecer) = ");
    Serial.print(IluminacionAmanecer);
    Serial.print(" - I(dia) = ");
    Serial.print(IluminacionDia);
    Serial.print(" - I(tarde) = ");
    Serial.print(IluminacionTarde);
    Serial.print(" - I(noche) = ");
    Serial.println(IluminacionNoche);
    Ilumina_Noche(NEO_PIXEL_LED_INICIAL,NEO_PIXEL_LED_FINAL,IluminacionTarde);
    Esperar(MILISEGUNDOS);
  }
}

//INICIALIZACION
void setup()
{
  // put your setup code here, to run once:
  Tira_LED.begin();
  Serial.begin(9600);
  Serial.println("");
  Serial.println("+++++++++++++++++++++++++++++++++++++++++++++");
  Serial.println("+++++ I N I C I O  D E  P R O G R A M A +++++");
  Serial.println("+++++++++++++++++++++++++++++++++++++++++++++");

  //AL PRINCIPIO TODOS LOS LEDS ESTAN APAGADOS
  Tira_LED.setPixelColor(0 ,Tira_LED.Color(0,0,0));
  Tira_LED.setPixelColor(1 ,Tira_LED.Color(0,0,0));
  Tira_LED.setPixelColor(2 ,Tira_LED.Color(0,0,0));
  Tira_LED.setPixelColor(3 ,Tira_LED.Color(0,0,0));
  Tira_LED.setPixelColor(4 ,Tira_LED.Color(0,0,0));
  Tira_LED.setPixelColor(5 ,Tira_LED.Color(0,0,0));
  Tira_LED.setPixelColor(6 ,Tira_LED.Color(0,0,0));
  Tira_LED.setPixelColor(7 ,Tira_LED.Color(0,0,0));
  Tira_LED.setPixelColor(8 ,Tira_LED.Color(0,0,0));
  Tira_LED.setPixelColor(9 ,Tira_LED.Color(0,0,0));
  Tira_LED.setPixelColor(10 ,Tira_LED.Color(0,0,0));
  Tira_LED.setPixelColor(11 ,Tira_LED.Color(0,0,0));
  Tira_LED.setPixelColor(12 ,Tira_LED.Color(0,0,0));
  Tira_LED.setPixelColor(13 ,Tira_LED.Color(0,0,0));
  Tira_LED.setPixelColor(14 ,Tira_LED.Color(0,0,0));
  Tira_LED.setPixelColor(15 ,Tira_LED.Color(0,0,0));
  //EL BRILLO ES IGUAL A CERO
  Tira_LED.setBrightnessPixel(0,0);
  Tira_LED.setBrightnessPixel(0,1);
  Tira_LED.setBrightnessPixel(0,2);
  Tira_LED.setBrightnessPixel(0,3);
  Tira_LED.setBrightnessPixel(0,4);
  Tira_LED.setBrightnessPixel(0,5);
  Tira_LED.setBrightnessPixel(0,6);
  Tira_LED.setBrightnessPixel(0,7);
  Tira_LED.setBrightnessPixel(0,8);
  Tira_LED.setBrightnessPixel(0,9);
  Tira_LED.setBrightnessPixel(0,10);
  Tira_LED.setBrightnessPixel(0,11);
  Tira_LED.setBrightnessPixel(0,12);
  Tira_LED.setBrightnessPixel(0,13);
  Tira_LED.setBrightnessPixel(0,14);
  Tira_LED.setBrightnessPixel(0,15);
  //SE HACE VISIBLE EL COLOR
  Tira_LED.show();
}

//CICLO PRINCIPAL
void loop()
{
  // put your main code here, to run repeatedly:
  Fase_Amanecer();
  Fase_Dia();
  Fase_Tarde();
  Fase_Noche();
}

