/***************************************************
Copyright (c) 2017 Luis Llamas
(www.luisllamas.es)

Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License
 ****************************************************/

#include "AsyncTaskLib.h"

const int TIEMPO_FASE_AMANECER = 5000;
const int TIEMPO_FASE_DIA = 7000;
const int TIEMPO_FASE_ATARDECER = 11000;
const int TIEMPO_FASE_NOCHE = 13000;

void Amanecer()
{
  Serial.print("FIN NOCHE = [ ");
  Serial.print((millis()/1000));
  //Serial.println(" ]");
  
  Serial.print(" ] - INICIO AMANECER = [ ");
  Serial.print((millis()/1000));
  Serial.println(" ]");
}

void Dia()
{
  Serial.print("FIN AMANECER = [ ");
  Serial.print((millis()/1000));
  //Serial.println(" ]");
  
  Serial.print(" ] - INICIO DIA = [ ");
  Serial.print((millis()/1000));
  Serial.println(" ]");
}

void Atardecer()
{
  Serial.print("FIN DIA = [ ");
  Serial.print((millis()/1000));
  //Serial.println(" ]");
  
  Serial.print(" ] - INICIO ATARDECER = [ ");
  Serial.print((millis()/1000));
  Serial.println(" ]");
}

void Noche()
{
  Serial.print("FIN ATARDECER = [ ");
  Serial.print((millis()/1000));
  //Serial.println(" ]");
  
  Serial.print(" ] - INICIO NOCHE = [ ");
  Serial.print((millis()/1000));
  Serial.println(" ]");
}

AsyncTask FaseAmanecer(TIEMPO_FASE_AMANECER, []() { Amanecer(); });

AsyncTask FaseDia(TIEMPO_FASE_DIA, []() { Dia(); });

AsyncTask FaseAtardecer(TIEMPO_FASE_ATARDECER, []() { Atardecer(); });

AsyncTask FaseNoche(TIEMPO_FASE_NOCHE, []() { Noche(); });

void setup()
{
	
  Serial.begin(9600);  
  Serial.println("+++++++++++++++++++++++++++++++");
  Serial.println("+++++ INICIO DEL PROGRAMA +++++");
  Serial.println("+++++++++++++++++++++++++++++++");

  Serial.print("FASE AMANECER = ");
  Serial.print(TIEMPO_FASE_AMANECER/1000);
  Serial.println(" SEGUNDOS");

  Serial.print("FASE AMANECER = ");
  Serial.print(TIEMPO_FASE_DIA/1000);
  Serial.println(" SEGUNDOS");
  
  Serial.print("FASE AMANECER = ");
  Serial.print(TIEMPO_FASE_ATARDECER/1000);
  Serial.println(" SEGUNDOS");
  
  Serial.print("FASE AMANECER = ");
  Serial.print(TIEMPO_FASE_NOCHE/1000);
  Serial.println(" SEGUNDOS");
  
	FaseAmanecer.Start();
}

void loop()
{
	FaseAmanecer.Update(FaseDia);
	FaseDia.Update(FaseAtardecer);
  FaseAtardecer.Update(FaseNoche);
  FaseNoche.Update(FaseAmanecer);
}


