;************************************************************************
; PRESEPE4.ASM Rev.4
; 9/11/2003
; Autore: Sasa Sbarra
; Varia la luce di 5 lampadine a filamento simulando l'effetto Alba/
; Giorno/Tramonto/Notte e Stelle (effetto tremolante) di un presepe.
; Inotre pilota 5 uscite ON-OFF denominate ZONA1,ZONA2,ZONA3,ZONA4,ZONA5 per
; pilotare le luci delle case oppure i motori dei pastori.
; La giornata completa  suddivisa in 4 fasi come di seguito descritto:
; - Alba:       Lampada ALBA crescente e poi decrescente
;               Lampada GIORNO crescente
;               Lampada TRAMONTO spenta
;               Lampada NOTTE decrescente
;               Lampada STELLE decrescente
;               Uscite ZONA1, ZONA2, ZONA3 in OFF
;               Uscita ZONA4 in ON e successivamente OFF
;               Uscita ZONA5 in OFF

; - Giorno:     Lampada ALBA spenta
;               Lampada GIORNO accesa massima luminosit
;               Lampada TRAMONTO spenta
;               Lampada NOTTE spenta
;               Lampada STELLE spenta
;               Uscite ZONA1, ZONA2, ZONA3, ZONA4 in OFF
;               Uscita ZONA5 in ON

; - Tramonto    Lampada ALBA spenta
;               Lampada GIORNO decrescente
;               Lampada TRAMONTO crescente e poi decrescente
;               Lampada NOTTE crescente
;               Lampada STELLE crescente
;               Uscite ZONA1, ZONA2, ZONA3 accese in sequenza (ON)
;               Uscita ZONA4 in OFF
;               Uscita ZONA5 in OFF

; - Notte:      Lampada ALBA spenta
;               Lampada GIORNO spenta
;               Lampada TRAMONTO spenta
;               Lampada NOTTE accesa massima luminosit
;               Lampada STELLE accesa con effetto
;               Uscita ZONA4 in ON
;               Uscite ZONA1, ZONA2, ZONA3 spente (OFF) in sequenza
;               Uscita ZONA5 in OFF

; Il tempo di esecuzione dell'intero ciclo (giornata) pu essere variato
; da 1 a 15 minuti agendo su un pulsante e contando i lampeggi di un led:

; LETTURA MINUTI IMPOSTATI INTERO CICLO "Giornata"
; - Premere il pulsante e mantenerlo premuto finch il led TIME si spegne.
;   Gli effetti luminosi andranno in pausa (si bloccheranno).
; - Rilasciare il pulsante. Il led TIME lampegger un numero di volte (1..15)
;   corrispondente al tempo in minuti impostato per l'intero ciclo.
; - Segue una pausa di 2 secondi con il led spento e due lampeggi veloci del
;   led (fine operazione). Gli effetti riprenderanno normalmente e il led
;   TIME lampegger ad indicare lo scorrere del tempo.

; IMPOSTAZIONE MINUTI INTERO CICLO "Giornata"
; - Premere il pulsante TIME e mantenerlo premuto
; - Premere e rilasciare il pulsante RESET
; - Contare i lampeggi del led TIME
; - Rilasciare il pulsante TIME quando il numero dei lampeggi contati
;   corrisponde al tempo in minuti dell'intero ciclo (giornata).
; - Segue una pausa di 2 secondi con il led spento e due lampeggi veloci del
;   led (fine operazione). Gli effetti riprendono da inizio ciclo e il led
;   TIME lampegger ad indicare lo scorrere del tempo.
;   Il valore del tempo corrispondente all'intero ciclo (variabile TimeMin) 
;   salvata in memoria EEPROM per essere ripristinato ogni volta che si
;   accende il circuito.
;   NOTA: Alla funzione "Impostazione Minuti" si pu accedere anche in
;   successione da "Lettura Minuti Impostati" mantenendo premuto il pulsante
;   TIME dopo i lampeggi di fine operazione della prima funzione.

; Per ottenere una temporizzazione variabile, ciascuna Fase A/G/T/N  stata
; suddivisa in un numero definito di passi (step). Variando il tempo del
; singolo passo si varia il tempo totale dell'intero ciclo (giornata).
; Le fasi Alba e Tramonto sono formate da 256 passi, mentre Giorno e Notte da
; 512 passi. Un ciclo intero (Giornata A,G,T,N) sar formata da 1536 passi

; Passi Giornata= P_Alba + P_Giorno + P_Tram + P_Notte= 256+512+256+512=1536

; Le fasi Alba e Tramonto durano quindi la met di Giorno/Notte.
; Il lampeggio pi o meno veloce del led TIME indica lo scorrere del tempo.

;   Tempo ciclo    |  Tempo  | Tempo |  Tempo   | Variab  |  Tempo
;   Lamp. LED      |  Giorno | Alba  |  Passo   | StepTim |  Reale ciclo
;   Var. TIME_MIN  |  Notte  | Tram  | (t/1536) | (*10mS) |
; ---------------------------------------------------------------------------
;    1 min (60s)      20s      10s      40mS       4         61s
;    2 min (120s)     40s      20s      78mS       8         122s
;    3 min (180s)     60s      30s      117mS      12        184s
;    4 min (240s)     80s      40s      156mS      16        245s
;    5 min (300s)     100s     50s      195mS      20        307s
;    6 min (360s)     120s     60s      234mS      24        368s
;    7 min (420s)     140s     70s      273mS      28        430s
;    8 min (480s)     160s     80s      312mS      32-1      476s
;    9 min (540s)     180s     90s      351mS      36-1      537s
;   10 min (600s)     200s     100s     390mS      40-1      599s
;   11 min (660s)     220s     110s     429mS      44-1      660s
;   12 min (720s)     240s     120s     468mS      48-1      721s
;   13 min (780s)     260s     130s     507mS      52-1      783s
;   14 min (840s)     280s     140s     546mS      56-1      844s
;   15 min (900s)     300s     120s     585mS      60-1      906s

; E'stato utilizzato un quarzo da 4 MHz.

;************************************************************************

        PROCESSOR       16F84                   ;Tipo di processore
        RADIX           DEC                     ;decimali senza notaz.
        INCLUDE         "PIC16F84.INC"          ;inclusione File .inc
        ERRORLEVEL      -302
        __CONFIG        3FF5H                   ;Nessuna protezione codice
                                                ;Watch-dog abilitato
                                                ;Power Up abilitato
                                                ;Oscillatore tipo XT
;************************************************************************
;Dichiarazione costanti utilizzate dal compilatore
LP_A    EQU     7               ;Numero portaB associata Lampada ALBA
LP_G    EQU     6               ;Numero portaB associata Lampada GIORNO
LP_T    EQU     5               ;Numero portaB associata Lampada TRAMONTO
LP_N    EQU     4               ;Numero portaB associata Lampada Notte
LP_ST   EQU     3               ;Numero portaB associata Lampada STELLE
ZONA1   EQU     2               ;Numero portaB associata ZONA1
ZONA2   EQU     1               ;Numero portaB associata ZONA2
ZONA3   EQU     4               ;Numero portaA associata ZONA3
ZONA4   EQU     3               ;Numero portaA associata ZONA4
ZONA5   EQU     2               ;Numero portaA associata ZONA4
P_TIME  EQU     1               ;Numero portaA associata ingresso puls. TIME
LED_TIM EQU     0               ;Numero portaA associata uscita Led TIME
EA_TIME EQU     0               ;Indirizzo EEPROM per recupero var. TimeMin

;************************************************************************
;Dichiarazione variabili in area dati (0C=locazione di partenza RAM)
        ORG     0CH
Alba    RES     1               ;Luminosit lamp Alba: 0=spenta..127=massima
Giorno  RES     1               ;Lumin. lamp Giorno: 0=spenta..127=massima
Tram    RES     1               ;Lumin. lamp Tramonto: 0=spenta..127=massima
Notte   RES     1               ;Lumin. lamp Notte: 0=spenta..127=massima
Stelle  RES     1               ;Lumin. lamp Stelle: 0=spenta..127=massima
Fase    RES     1               ;Fase della giornata: 1=Alba 2,3=Giorno
                                ;4=Tramonto 5,6=Notte
CntStep RES     1               ;Contatore 255 passi in ciascuna delle fasi
StepTim RES     1               ;Tempo del singolo passo (moltiplicare *10mS)
Cnt10ms RES     1               ;Contatore incrementato ogni 10mS sul fronte
                                ;positivo di RB0 (Frequenza rete 50x2=100Hz)
CntZero RES     1	        ;Attesa 100uS in Rbo_Int
TimeMin RES     1               ;Valore del tempo intero ciclo (1..15 minuti)
Cnt_Lp  RES     1               ;Contatore ritardo conduzione triac. Viene
                                ;decrementata in Tim-Int da 127 a 0
Casual  RES     1               ;Generatore livelli casuali per lamp. Stelle
DelStar RES     1               ;Tempo (10..100)*0,5mS ritardo variabile per
                                ;effetto tremolio Stelle
Cnt_Dst RES     1               ;Contatore per ritardo variabile eff. Stelle
Tmp_Shf RES     1               ;Appoggio operazioni
Cnt_Set RES     1               ;Contatore per settaggio tempo ciclo
Cnt_Del RES     3               ;3 Contatori per ritardo
W_Temp  RES     1               ;Salvataggio registro W durante Interrupt
St_Temp RES     1               ;Salvataggio registro STATUS durante Interrupt


;************************************************************************
;Inizio memoria programma (locazione 00)
        ORG     00H
        goto    start

;*********************************************************************
;Interrupt handler. Possono essere generati due tipi di interrupt:
; -Porta RB0: Generato ogni volta che il segnale di zero-crossing (passaggio
;  sullo zero della tensione sinosoidale ogni 10 mS) passa da 0 a 1.
;  Inizializza il contatore Cnt_Lp e pone a zero l'uscita delle lampade.
; -TIMER: Utilizzato per decrementare ogni 78 uS la variabile Cnt_Lp e per
;  pilotare i triac in ritardo rispetto al passaggio sullo zero quando si
;  verifica la condizione VALORE_LAMPADINA>=Cnt_Lp.
;Alla fine dell'interrupt viene eseguita end_ih.
        ORG     04H
        movwf   W_Temp          ;Salvataggio registro W in W_Temp
        swapf   STATUS,W        ;Salvataggio registro STATUS in St_Temp
        movwf   St_Temp

        clrwdt                  ;Azzera il watch-dog
        btfsc   INTCON,INTF     ;Verifica se generato l'Interrupt su RB0
        goto    rb0_int         ;Salta a Rb0 Interrupt se INTF=1
        goto    tim_int         ;Salta a Timer Interrupt se INTF=0

end_ih  swapf   St_Temp,W       ;Riprisino registro STATUS
        movwf   STATUS
        swapf   W_Temp,F        ;Ripristino registro W
        swapf   W_Temp,W
        retfie

;*** Interrupt Timer ***
;Si verifica questo interrupt quando il registro TMR0, continuamente incre-
;mentato ogni 2 uS, arriva a 0. E'utilizzata per decrementare da 127 a 0 la
;variabile Cnt_Lp che stabilisce i 'passi' del ritardo di conduzione del
;triac rispetto al passaggio sullo zero della tensione sinosoidale.
;Inoltre pone a 1 le 4 uscite delle lampade Alba/Giorno/Tramonto/Notte
;(collegate al triac) quando VALORE_LAMPADA>=Cnt_Lp.
;Il triac rimarr in conduzione fino al prossimo passaggio sullo zero.
tim_int movlw   224             ;Ricarica TMR0 per far eseguire tim_int
        movwf   TMR0            ;ogni 78 uS (comprese le istruzioni
			        ;precedenti di scelta interrupt).

        movf    Cnt_Lp,w        ;Lampada Alba
        subwf   Alba,w          ;w = Alba - Cnt_Lp
        btfsc   STATUS,C        ;Se Alba<Cnt_Lp salta prossima istruzione
        bsf     PORTB,LP_A      ;Porta in conduzione il triac che pilota la
                                ;lampadina Alba in ritardo rispetto allo 0

        movf    Cnt_Lp,w        ;Lampada Giorno
        subwf   Giorno,w
        btfsc   STATUS,C
        bsf     PORTB,LP_G

        movf    Cnt_Lp,w        ;Lampada Tramonto
        subwf   Tram,w
        btfsc   STATUS,C
        bsf     PORTB,LP_T

        movf    Cnt_Lp,w        ;Lampada Notte
        subwf   Notte,w
        btfsc   STATUS,C
        bsf     PORTB,LP_N

        movf    Cnt_Lp,w        ;Lampada Stelle
        subwf   Stelle,w
        btfsc   STATUS,C
        bsf     PORTB,LP_ST

        movf    Cnt_Lp,f        ;Se Cnt_Lp<>0 decrementa Cnt_Lp
        btfss   STATUS,Z        ;Salta prossima se Cnt_Lp=0
        decf    Cnt_Lp,f        ;Decrementa Cnt_Lp

        bcf     INTCON,T0IF     ;Riabilita interrupt su TMR0
        goto    end_ih


;*** Interrupt RB0 ***
;Si verifica questo interrupt quando l'ingresso RB0 passa da 0 a 1 in presenza
;dello 'zero' della tensione sinosoidale di rete. Serve a porre a 0 le uscite
;dei 4 triac associati alle lampade e a inizializzare la variabile Cnt_Lp.
;Inoltre  utilizzato per incrementare Cnt10ms ogni 10 mS (100Hz) fino al
;valore StepTim, impostato sul commutatore binario.
rb0_int bcf     PORTB,LP_A      ;Pone a 0 le uscite dei triac per 4 Lampade
        bcf     PORTB,LP_G      ;Alba/Giorno/Tramonto/Notte/Stelle
        bcf     PORTB,LP_T
        bcf     PORTB,LP_N
        bcf     PORTB,LP_ST

        movlw   127             ;Inizializza Cnt_Lp a 127
        movwf   Cnt_Lp

        movf    Cnt10ms,w       ;Incrementa Cnt10ms se diverso da StepTim
        xorwf   StepTim,w
        btfss   STATUS,Z
        incf    Cnt10ms,f

  	movlw   33		;Attesa 100uS per non far eseguire tim_int
	movwf   CntZero	  	;(generazione passi) prima che la tensione
w_zero  decfsz  CntZero,f	;sinosoidale arrivi realmente a zero.
	goto    w_zero

        bcf     INTCON,INTF     ;Riabilita interrupt su RB0
        goto    end_ih


;*****************************************************
;Programma PRINCIPALE

;Configurazione porte I/O (0=Out 1=In) e settaggio interrupt e prescaler
start   bsf     STATUS,RP0      ;Banco memoria 1

        movlw   11100010B       ;Configurazione Porta A
        movwf   TRISA           ;RA0: uscita Led TIME
                                ;RA1: ingresso pulsante TIME
                                ;RA2: uscita ZONA5
                                ;RA3: uscita ZONA4
                                ;RA4: uscita ZONA3
                                ;RA5,RA6,RA7: non presenti

        movlw   00000001B       ;Configurazione Porta B
        movwf   TRISB           ;RB0: ingresso zero crossing tensione rete
                                ;RB1: uscita ZONA2
                                ;RB2: uscita ZONA1
                                ;RB3: uscita triac lampada Stelle
                                ;RB4: uscita triac lampada Notte
                                ;RB5: uscita triac lampada Tramonto
                                ;RB6: uscita triac lampada Giorno
                                ;RB7: uscita triac lampada Alba

        movlw   01000000B       ;bit7: Attiva circuiteria weak-up ingressi
        movwf   OPTION_REG      ;bit6: Attiva interrupt RB0 su fronte salita
                                ;bit5: Ingresso prescaler a fOsc/4 (1 MHz)
                                ;bit3: Ingresso registro TMR0 a Prescaler
                                ;bit2,1,0: Divisione prescaler 2 volte
                                ;Frequenza uscita prescaler = 500000 Hz

        bcf     STATUS,RP0      ;Banco memoria 0

        clrf    Alba            ;Inizializza valori luminosit in partenza
        clrf    Giorno
        clrf    Tram
        movlw   127
        movwf   Notte
        movwf   Stelle

        movlw   1               ;Alba: Fase=1
        movwf   Fase

        movlw   10              ;Contatore ritardo Stelle minimo (5mS)
        movwf   DelStar         ;e inizializzazione variabile livelli casuali
        movwf   Cnt_Dst
	clrf	Casual

        bcf     PORTB,ZONA1     ;Inizializza uscite ON-OFF
        bcf     PORTB,ZONA2     ;Uscite ZONA1,2,3,5 OFF (spente)
        bcf     PORTA,ZONA3     ;Uscita ZONA4 ON (accesa)
        bsf     PORTA,ZONA4
        bcf     PORTA,ZONA5

        clrwdt                  ;Azzera watch-dog
        clrf    CntStep         ;Azzeramento contatore passi
        clrf    Cnt10ms         ;Azzeramento contatore 10 mS

        call    loadsteptime    ;Carica in StepTim il valore di tempo del
                                ;singolo passo calcolato da TimeMin e a sua
                                ;volta prelevato dalla memoria EEPROM

        movlw   10110000B       ;Abilita Interrupt su Timer e su porta RB0
        movwf   INTCON

;Controlla se il pulsante TIME  gi premuto per settare il tempo del ciclo
        btfss   PORTA,P_TIME    ;Se pulsante non premuto salta a mainloop
        goto    main01          ;Settaggio tempo ciclo

;Se Cnt10ms=StepTim (Cnt10ms  incrementata ogni 10mS da rb0_int) salta main0
;Si effettua questo test ogni 500uS circa (ritardo per effetti Stelle) in modo
;da non far crescere il tempo del ciclo totale (giornata).
mainloop                        ;Loop principale
        movlw   20              ;Inizializza Cnt_Set=20 per attesa pressione
        movwf   Cnt_Set         ;pulsante TIME per pi di 2 secondi

        call    del05ms         ;Ritardo 0,5mS per tremolio Stelle
        call    drive_stars     ;Pilotaggio Stelle

        movf    Cnt10ms,w       ;Controlla se Cnt10ms=StepTim
        xorwf   StepTim,w
        btfss   STATUS,Z
        goto    main00          ;Se Cnt10ms<>StepTim controlla pulsante
        goto    main0           ;altrimenti se Cnt10ms=StepTim continua

;Verifica la pressione continuata per 2 secondi del pulsante TIME per conoscere
;il tempo dell'intero ciclo (contando i lampeggi del led TIME).
;Richiama la sub viewtimemin per questo scopo
main00  btfsc   PORTA,P_TIME
        goto    mainloop        ;Se pulsante TIME non premuto, attende
        bcf     PORTA,LED_TIM   ;Accende fisso il led del tempo (invertito)
        call    del_01s         ;Ritardo 100 mS
        decfsz  Cnt_Set,F       ;Decrementa Cnt_Set e salta prossima se Cnt_Set=0
        goto    main00          ;Attende 2 secondi di pressione pulsante TIME

        bsf     PORTA,LED_TIM   ;Spegne il led del tempo (invertito)
        call    viewtimemin     ;Visualizza il tempo dell'intero ciclo
        call    blkendoper      ;Lampeggio fine operazione e ritardo 2 secondi

;Controlla, dopo 2 secondi dalla fine della visualizzazione, che il pulsante
;TIME sia ancora premuto per accedere alla Fase di settaggio del tempo.
        btfsc   PORTA,P_TIME
        goto    main0           ;Se non premuto continua il ciclo precedente
main01  call    settimemin      ;Se premuto settaggio del tempo ciclo
                                ;totale e salvataggio su EEPROM per ripristino
        call    blkendoper      ;Lampeggio fine operazione e ritardo 2 secondi
        goto    start           ;Ricomincia dall'inizio

;Richiama la Sub associata alla Fase corrispondente della giornata
;(Fase=1 Alba - Fase=2,3 Giorno - Fase=4 Tramonto - Fase=5,6 Notte)
main0   clrf    Cnt10ms         ;Se Cnt10ms=StepTim,azzera Cnt10ms

        call    blink_led       ;Fa lampeggiare il led per indicare lo
                                ;scorrere del tempo

        movf    Fase,w          ;Se Fase=1 (Alba) richiama Sub fase_alba
        xorlw   1
        btfss   STATUS,Z
        goto    main1
        call    fase_alba
        goto    main5

main1   movf    Fase,w          ;Se Fase=2,3 (Giorno) richiama Sub fase_giorno
        xorlw   2
        btfss   STATUS,Z
        goto    main2
        call    fase_giorno
        goto    main5
main2   movf    Fase,w
        xorlw   3
        btfss   STATUS,Z
        goto    main3
        call    fase_giorno
        goto    main5

main3   movf    Fase,w          ;Se Fase=4 (Tramonto) richiama Sub Fase_Tram
        xorlw   4
        btfss   STATUS,Z
        goto    main4
        call    fase_tramonto
        goto    main5

main4   call    fase_notte      ;Se Fase=5,6 (Notte) richiama Sub fase_notte

;Alla fine verifica se  il momento di accendere/spegnere le 5 uscite ZONE
main5   call    drive_zones
        goto    mainloop


;*****************************************************
;Subroutine LoadStepTime
;Carica nella variabile StepTim il tempo del singolo passo. Per ottenere il
;reale tempo in mS  necessario moltiplicare il numero per 10.
;Considerando 1536 passi totali, il tempo totale del ciclo giornata si calcola
;    Tempo_Ciclo_Giornata = Tempo_Passo * Numero_Passi_Totali (cio 1536)
;Si appoggia a TimeMin, contenente il tempo in minuti dell'intero ciclo
;(1..15), recuperata dalla EEPROM (locazione EA_TIME) per effettuare il
;ripristino automatico ogni volta che si alimenta il circuito.

loadsteptime                    ;Recupera da EEPROM il valore TimeMin
        movlw   EA_TIME         ;Indirizzo EEPROM
        movwf   EEADR
        bsf     STATUS,RP0
        bsf     EECON1,RD       ;Inizio Fase lettura valore
        bcf     STATUS,RP0
        movf    EEDATA,w        ;Carica byte letto in TimeMin
        movwf   TimeMin

;Verifica se il valore prelevato  corretto (1..15). Questa condizione si
;ha quando non si  ancora memorizzato per la prima volta un valore in EEPROM
        movf    TimeMin,w
        btfsc   STATUS,Z        ;Se TimeMin=0 salta prossima
        goto    lst_1
        sublw   15              ;w=15-TimeMin
        btfss   STATUS,C        ;Se TimeMin<=15 salta a lst_2
        goto    lst_1
        goto    lst_2
lst_1   movlw   1               ;Se valore TimeMin errato, carica default 1
        movwf   TimeMin

;Calcola il valore corrispondente StepTim con la moltiplicazione TimeMin*4
;Se TimeMin>=8 effettua correzione sottraendo 1 a StepTim.
lst_2   movf    TimeMin,w       ;Cnt_Set=TimeMin
        movwf   Cnt_Set
        clrw                    ;Azzera w
lst_3   addlw   4               ;Somma 4 al contenuto di w
        decfsz  Cnt_Set,f       ;Decrementa Cnt_Set. Se Cnt_Set=0 salta prossima
        goto    lst_3           ;Ripete ciclo finch Cnt_Set=0
        movwf   StepTim         ;Salva valore di w in StepTim

        movf    TimeMin,w       ;Se TimeMin>=8 effetta correzione StepTim-1
        sublw   7               ;w=7-TimeMin
        btfsc   STATUS,C        ;Salta prossima se TimeMin>=8
        return
        movlw   1               ;Correzione StepTim=StepTim-1
        subwf   StepTim,f
        return

;*****************************************************
;Subroutine ViewTimeMin
;Utilizzata per visualizzare (contando i lampeggi del diodo led), il tempo
;complessivo in minuti di durata dell'intero ciclo (variabile TimeMin). 
viewtimemin
        call    del_1s          ;Ritardo
        movf    TimeMin,w       ;Cnt_Set = TimeMin
        movwf   Cnt_Set
vtm_1   bcf     PORTA,LED_TIM
        call    del_01s         ;Pausa 0,1 secondi led acceso
        bsf     PORTA,LED_TIM
        call    del_05s         ;Pausa 0,5 secondi led spento
        decfsz  Cnt_Set,f       ;Decrementa Cnt_Set. Salta prossima se Cnt_Set=0
        goto    vtm_1
        return

;*****************************************************
;Subroutine SetTimeMin
;Settaggio del tempo (da 1 a 15 minuti) dell'intero ciclo al rilascio del
;pulsante, contando i lampeggi del led.
;Il valore del tempo corrispondente all'intero ciclo (variabile TimeMin) 
;salvata in memoria EEPROM per essere ripristinato ogni volta che si accende
;il circuito.
;Durante le operazioni di settaggio tutte le uscite sono spente.
settimemin
        clrf    Alba            ;Spegne tutte le luci
        clrf    Giorno
        clrf    Tram
        clrf    Notte
        clrf    Stelle

        bcf     PORTB,ZONA1     ;Pone ad OFF tutti le uscite ON-OFF
        bcf     PORTB,ZONA2     ;(ZONA1,2,3,4,5)
        bcf     PORTA,ZONA3
        bcf     PORTA,ZONA4
        bcf     PORTA,ZONA5

        call    del_1s          ;Ritardo 1 secondo

stm_1   movlw   1               ;Fa lampeggiare il led fino al rilascio
        movwf   Cnt_Set         ;del pulsante. Alla fine si pone TimeMin=Cnt_Set.
stm_2   bcf     PORTA,LED_TIM
        call    del_01s         ;Pausa 0,1 secondi led acceso
        bsf     PORTA,LED_TIM
        call    del_05s         ;Pausa 0,5 secondi led spento
        btfsc   PORTA,P_TIME    ;Controlla se pulsante premuto
        goto    stm_3           ;Pulsante non premuto. Salta
        incf    Cnt_Set,f       ;Incrementa Cnt_Set
        btfss   Cnt_Set,4       ;Cnt_Set=16? (16=00010000B)
        goto    stm_2           ;No, effettua lampeggio successivo del led
        call    del_1s          ;Pausa 1 secondo
        goto    stm_1           ;Pulsante non rilasciato: ricomincia daccapo

stm_3   movf    Cnt_Set,w       ;TimeMin=Cnt_Set
        movwf   TimeMin
        call    saveeeprom      ;Salva TimeMin su EEPROM e disabilita interrupt
        return

;*****************************************************
;Subroutine SaveEEprom
;Salvataggio TimeMin su EEPROM
saveeeprom
        movlw   EA_TIME         ;Indirizzo memoria EEPROM
        movwf   EEADR
        movf    TimeMin,w       ;Valore da scrivere su EEPROM
        movwf   EEDATA
        bsf     STATUS,RP0      ;Memoria Banco 1
        bcf     INTCON,GIE      ;Disabilita tutti gli interrupt
        bsf     EECON1,WREN     ;Abilitazione scrittura
        movlw   85              ;Sequenza obbligata
        movwf   EECON2
        movlw   170
        movwf   EECON2
        bsf     EECON1,WR       ;Partenza scrittura
see_1   btfsc   EECON1,WR       ;Aspetta fine scrittura
        goto    see_1
        bcf     EECON1,WREN     ;Disabilita scrittura EEPROM
        bcf     STATUS,RP0      ;Memoria Banco 0
        return

;*****************************************************
;Subroutine fase_alba
;Gestisce le temporizzazioni relative alla Fase Alba del ciclo Giornata
;La variabile Fase=1
fase_alba
        btfsc   CntStep,0       ;Se CntStep pari e CntStep<>0 incrementa lum.
        goto    fa_1            ;Giorno e decrementa luminosit Notte.
        movf    CntStep,w
        btfsc   STATUS,Z
        goto    fa_1
        incf    Giorno,f
        decf    Notte,f

fa_1    btfss   CntStep,7       ;Se CntStep>=128 decrementa luminosit Alba
        goto    fa_2            ;altrimenti incrementa luminosit
        comf    CntStep,w
        movwf   Alba            ;Decrementa luminosit Alba
        goto    fa_3
fa_2    movf    CntStep,w       ;Incrementa luminosit Alba
        movwf   Alba

fa_3    movf    CntStep,w       ;Se CntStep=255 termine Fase Alba e
        xorlw   255             ;inizializza la Fase Giorno
        btfsc   STATUS,Z
        goto    fa_4
        incf    CntStep,f       ;Se CntStep<>255 incrementa CntStep
        return
fa_4    movlw   2
        movwf   Fase            ;Fase=2 Fase Giorno
        clrf    CntStep         ;Azzera contatore passi
        clrf    Alba            ;Lampada Alba spenta
        movlw   127             ;Lampada Giorno accesa
        movwf   Giorno
        clrf    Tram            ;Lampada Tramonto spenta
        clrf    Notte           ;Lampada Notte spenta
        return

;*****************************************************
;Subroutine fase_giorno
;Gestisce le temporizzazioni relative alla Fase Giorno del ciclo Giornata
;La variabile Fase=2,3
fase_giorno
        movf    CntStep,w       ;Se CntStep=255 salta a fg_1 per incrementare
        xorlw   255             ;la variabile Fase
        btfsc   STATUS,Z
        goto    fg_1
        incf    CntStep,f       ;Se CntStep<>255 incrementa contatore CntStep
        return
fg_1    incf    Fase,f          ;Incrementa Fase giornata
        clrf    CntStep         ;Azzera contatore passi
        return

;*****************************************************
;Subroutine fase_tramonto
;Gestisce le temporizzazioni relative alla Fase Tramonto del ciclo Giornata
;La variabile Fase=4
fase_tramonto
        btfsc   CntStep,0       ;Se CntStep pari e CntStep<>0 incrementa lum.
        goto    ft_1            ;Notte e decrementa luminosit Giorno.
        movf    CntStep,w
        btfsc   STATUS,Z
        goto    ft_1
        incf    Notte,f
        decf    Giorno,f

ft_1    btfss   CntStep,7       ;Se CntStep>=128 decrementa luminosit Tramonto
        goto    ft_2            ;altrimenti incrementa luminosit
        comf    CntStep,w
        movwf   Tram            ;Decrementa luminosit Tramonto
        goto    ft_3
ft_2    movf    CntStep,w       ;Incrementa luminosit Tramonto
        movwf   Tram

ft_3    movf    CntStep,w       ;Se CntStep=255 termine Fase Tramonto e
        xorlw   255             ;inizializza la Fase Notte
        btfsc   STATUS,Z
        goto    ft_4
        incf    CntStep,f       ;Se CntStep<>255 incrementa CntStep
        return
ft_4    movlw   5
        movwf   Fase            ;Fase=5: Notte
        clrf    CntStep         ;Azzera contatore passi
        clrf    Alba            ;Lampada Alba spenta
        clrf    Giorno          ;Lampada Giorno spenta
        clrf    Tram            ;Lampada Tramonto spenta
        movlw   127             ;Lampada Notte accesa
        movwf   Notte
        return

;*****************************************************
;Subroutine fase_notte
;Gestisce le temporizzazioni relative alla Fase Notte del ciclo Giornata
;La variabile Fase=5,6
fase_notte
        movf    CntStep,w       ;Se CntStep=255 salta a fn_1 per incrementare
        xorlw   255             ;la Fase Fase della giornata
        btfsc   STATUS,Z
        goto    fn_1
        incf    CntStep,f       ;Se CntStep<>255 incrementa CntStep
        return
fn_1    incf    Fase,f          ;Incrementa Fase giornata
        clrf    CntStep         ;Azzera contatore passi

        movf    Fase,w          ;Se Fase=7 (Fine ciclo) reinizializza alla
        xorlw   7               ;Fase Alba
        btfss   STATUS,Z
        return
        movlw   1               ;Inizializza Fase=1 (Alba)
        movwf   Fase
        return

;*****************************************************
;Subroutine blink_led
;Fa lampeggiare il led che indica lo scorrere del tempo.
;La velocit di lampeggio (singolo passo)  proporzionale alla durata dell'
;intero ciclo giornata.
blink_led
        btfss   PORTA,LED_TIM   ;Verifica lo stato del led. Se acceso salta
        goto    bled1
        bcf     PORTA,LED_TIM   ;Accende Led (Led collegato invertito)
        return
bled1   bsf     PORTA,LED_TIM   ;Spegne Led (Led collegato invertito)
        return

;*****************************************************
;Subroutine blkendoper
;Effettua 3 lampeggi veloci sul led preceduti e seguiti da una pausa di 1 sec.
;Utilizzata per indicare il "fine operazioni" di visualizzazione e settaggio.
blkendoper
        call    del_1s          ;Ritardo iniziale
        movlw   3               ;Cnt_Set=3
        movwf   Cnt_Set
beo_1   bcf     PORTA,LED_TIM   ;Accende Led (Led collegato invertito)
        call    del_01s
        bsf     PORTA,LED_TIM   ;Spegne Led (Led collegato invertito)
        call    del_01s
        decfsz  Cnt_Set,f       ;Decrementa Cnt_Set
        goto    beo_1           ;Salta se Cnt_Set<>0
        call    del_1s          ;Ritardo finale
        return

;*****************************************************
;Subroutine drive_zones
;Accende/Spegne le 5 uscite ON-OFF ZONA1,2,3,4,5 verificando la Fase della
;giornata (A,G,T,N) e il passo (variabile contatore CntStep).
;Si riassumono gli eventi ON-OFF delle 4 ZONE in corrispondenza delle
;variabili Fase e CntStep.
;
; - ZONA1       Start   Fase=4  CntStep=64
;               Stop    Fase=6  CntStep=64
; - ZONA2       Start   Fase=4  CntStep=128
;               Stop    Fase=6  CntStep=128
; - ZONA3       Start   Fase=4  CntStep=192
;               Stop    Fase=6  CntStep=192
; - ZONA4       Start   Fase=5  CntStep=64
;               Stop    Fase=1  CntStep=64
; - ZONA5       Start   Fase=2  CntStep=0
;               Stop    Fase=3  CntStep=255

drive_zones
        movf    Fase,w          ;Verifica se Fase=4 (Tramonto)
        xorlw   4
        btfss   STATUS,Z
        goto    z_drv1
        movf    CntStep,w       ;Verifica se CntStep=64 (ZONA1 ON)
        xorlw   64
        btfsc   STATUS,Z
        bsf     PORTB,ZONA1
        movf    CntStep,w       ;Verifica se CntStep=128 (ZONA2 ON)
        xorlw   128
        btfsc   STATUS,Z
        bsf     PORTB,ZONA2
        movf    CntStep,w       ;Verifica se CntStep=192 (ZONA3 ON)
        xorlw   192
        btfsc   STATUS,Z
        bsf     PORTA,ZONA3
        return

z_drv1  movf    Fase,w          ;Verifica se Fase=5 (Notte)
        xorlw   5
        btfss   STATUS,Z
        goto    z_drv2
        movf    CntStep,w       ;Veriica se CntStep=64 (ZONA4 ON)
        xorlw   64
        btfsc   STATUS,Z
        bsf     PORTA,ZONA4
        return

z_drv2  movf    Fase,w          ;Verifica se Fase=6 (Notte)
        xorlw   6
        btfss   STATUS,Z
        goto    z_drv3
        movf    CntStep,w       ;Verifica se CntStep=64 (ZONA1 OFF)
        xorlw   64
        btfsc   STATUS,Z
        bcf     PORTB,ZONA1
        movf    CntStep,w       ;Verifica se CntStep=128 (ZONA2 OFF)
        xorlw   128
        btfsc   STATUS,Z
        bcf     PORTB,ZONA2
        movf    CntStep,w       ;Verifica se CntStep=192 (ZONA3 OFF)
        xorlw   192
        btfsc   STATUS,Z
        bcf     PORTA,ZONA3
        return

z_drv3  movf    Fase,w          ;Verifica se Fase=1 (Alba)
        xorlw   1
        btfss   STATUS,Z
        goto    z_drv4
        movf    CntStep,w       ;Veriica se CntStep=64 (ZONA4 OFF)
        xorlw   64
        btfsc   STATUS,Z
        bcf     PORTA,ZONA4
        return

z_drv4  movf    Fase,w          ;Verifica se Fase=2 (Giorno)
        xorlw   2
        btfss   STATUS,Z
        goto    z_drv5
        movf    CntStep,w       ;Veriica se CntStep=0 (ZONA5 ON)
        btfsc   STATUS,Z
        bsf     PORTA,ZONA5
        return

z_drv5  movf    Fase,w          ;Verifica se Fase=3 (Giorno)
        xorlw   3
        btfss   STATUS,Z
        return
        movf    CntStep,w       ;Veriica se CntStep=255 (ZONA5 OFF)
        xorlw   255
        btfsc   STATUS,Z
        bcf     PORTA,ZONA5
        return

;*****************************************************
;Subroutine drive_stars
;Genera l'effetto tremolante sulla lampada Stelle riducendo e aumentando
;la luminosit casualmente. La generazione del bit casuale (Casual,7) si
;effettua ad intervalli crescenti, da 5 a 50mS. La Sub  eseguita ogni 500uS
;La luminosit di Stelle  associata a Notte.
drive_stars
        decfsz  Cnt_Dst,f       ;Decrementa ritardo variabile
        return                  ;Esce se <>0

        movf    DelStar,w       ;Verifica se il ritardo tremolio  al massimo
        xorlw   100
        btfss   STATUS,Z
        goto    drst_1
        movlw   10              ;Imposta il ritardo tremolio al minimo
        movwf   DelStar
        goto    drst_2
drst_1  incf    DelStar,f       ;Incrementa ritardo tremolio
drst_2  movf    DelStar,w       ;Copia DelStar nel contatore Cnt_Dst
        movwf   Cnt_Dst

        btfss   Casual,6        ;Generazione numeri casuali in Casual ottenuta
        goto    drst_3          ;ruotandola a sinistra e facendo entrare in
        btfsc   Casual,5        ;carry 1 o 0 secondo la xor dei bit 6 e 5
        goto    drst_4
        goto    drst_5          ;       Casual,6  Casual,5   XOR
drst_3  btfsc   Casual,5        ;          0         0        1
        goto    drst_5          ;          0         1        0
                                ;          1         0        0
drst_4  bsf     STATUS,C        ;          1         1        1
	goto    drst_6
drst_5  bcf     STATUS,C
drst_6  rlf     Casual,f        ;ruota a sinistra Casual e fa entrare Carry

	movf    Notte,w         ;Quando Casual,7=0 decrementa del 25%
        btfsc   Casual,7        ;la luminosit di Stelle per simulare
        goto    drst_7          ;l'effetto del tremolio
        movwf   Tmp_Shf         ;Esempio: Se Notte=127, Stelle=127-31=96
        bcf     STATUS,C
        rrf     Tmp_Shf,f       ;divide di met
        bcf     STATUS,C
        rrf     Tmp_Shf,w       ;divide di met --> w=Notte/4
        subwf   Notte,w         ;Stelle=Notte-Notte/4 (-25%)
drst_7  movwf   Stelle
        return

;*****************************************************
;Subroutine delay
;Effettua ritardi da 100mS a 1 secondo

del_1s  movlw   10              ;Ritardo 1 secondi (10 * 100 mS)
        goto    delay
del_05s movlw   5               ;Ritardo 0,5 secondi (5 * 100 mS)
        goto    delay
del_01s movlw   1               ;Ritardo 0,1 secondi (1 * 100 mS)

delay   movwf   Cnt_Del+2
        movlw   100
        movwf   Cnt_Del+1
        clrf    Cnt_Del
delloop decfsz  Cnt_Del,f         ;Ciclo 1
        goto    delloop
        clrwdt
        decfsz  Cnt_Del+1,f       ;Ciclo 2
        goto    delloop
        decfsz  Cnt_Del+2,f       ;Ciclo 3
        goto    delloop
        return

;*****************************************************
;Subroutine del05ms
;Effettua un ritardo di 500 uS utilizzato per generare il ritardo variabile
;(10..100mS) per il tremolio delle Stelle.

del05ms movlw   166               ;Ritardo 500uS
        movwf   Cnt_Del

d05ms_l decfsz  Cnt_Del,f         ;Ciclo ritardo
        goto    d05ms_l
        return

        END                       ;Fine programma

